varying vec2 		texcoord;
varying float		dist;
uniform sampler2D 	tex;
uniform sampler2D 	noiseTex;
uniform vec4		ambientColor;	// ambient  * material color
varying vec4		diffuse;		// diffuse color * material color
varying vec4		fog;
varying float		alphaFade;

varying vec3 	Lin;
varying vec3 	Fex;

#ifdef _HEIGHTMAP_

	uniform sampler2D	cmask;	
	varying vec2 		texcoord2;
	
#endif

void main()
{
	vec4 color=texture2D(tex,texcoord.st);
	
	#ifdef _HEIGHTMAP_
		
		color*=texture2D(cmask,texcoord2.st);
		
	#else
		float alpha=texture2D(noiseTex,texcoord.st).r;
		if(alpha>alphaFade)
			discard;
	#endif
	
	if(dist<=0.0)
	{
		discard;
	}
	else
	{
		// convert normal to eye space
		//gl_FragColor.xyz=mix(fog.rgb,color.xyz*ambientColor.xyz + color.xyz*diffuse.xyz,fog.a);
		gl_FragColor.xyz=Lin+Fex*color.xyz*diffuse.xyz;
		gl_FragColor.a=color.a;
	}
}
